<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo e(config('app.name')); ?></title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_lte/plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_lte/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css')); ?>">
  <!-- iCheck -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_lte/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
  <!-- JQVMap -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_lte/plugins/jqvmap/jqvmap.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_lte/dist/css/adminlte.min.css')); ?>">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_lte/plugins/overlayScrollbars/css/OverlayScrollbars.min.css')); ?>">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_lte/plugins/daterangepicker/daterangepicker.css')); ?>">
  <!-- summernote -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_lte/plugins/summernote/summernote-bs4.min.css')); ?>">
  <!-- jQuery -->
  <script src="<?php echo asset('assets/js/jquery.min.js') ?>"></script>
  <!-- ajax form-->
  <script type="text/javascript" src="<?php echo asset('assets/js/jquery.form.min.js'); ?>"></script>
  <!-- extra resources --> 
  <link href="<?php echo asset('assets/css/icheck/flat/green.css'); ?>" rel="stylesheet" />
  <link rel="stylesheet" type="text/css" media="screen" href="<?php echo asset('assets/css/admin_lte_custom.css'); ?>" />
  <script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
   <?php $__env->startSection('head'); ?>
   <?php echo $__env->yieldSection(); ?>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

   <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?php echo e(url('/admin')); ?>" class="nav-link">Home</a>
      </li>
    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
      <li class="nav-item">
        <a class="nav-link" data-widget="fullscreen" href="#" role="button">
          <i class="fas fa-expand-arrows-alt"></i>
        </a>
      </li>
      <li class="nav-item">
        <a class="nav-link" data-widget="control-sidebar" data-slide="true" href="#" role="button">
          <i class="fas fa-th-large"></i>
        </a>
      </li>
      <li class="dropdown user user-menu open">
                      <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
                        <img src="<?php echo e(asset('admin_lte/dist/img/user2-160x160.jpg')); ?>" class="user-image" alt="User Image">
                        <span class="hidden-xs">Alexander Pierce</span>
                      </a>
                      <ul class="dropdown-menu">
                        <!-- User image -->
                        <li class="user-header">
                          <img src="<?php echo e(asset('admin_lte/dist/img/user2-160x160.jpg')); ?>" class="img-circle" alt="User Image">
                          <p>
                            Alexander Pierce - Web Developer
                            <small>Member since Nov. 2012</small>
                          </p>
                        </li>
                        <!-- Menu Footer-->
                        <li class="user-footer">
                          <div class="pull-left">
                            <a href="<?php echo e(route('userprofile')); ?>" class="btn btn-default btn-flat">Profile</a>
                          </div>
                          <div class="pull-right">
                            <a href="<?php echo e(route('logout')); ?>" class="btn btn-default btn-flat">Sign out</a>
                          </div>
                        </li>
                      </ul>
                    </li>
    </ul>
  </nav>
  <!-- /.navbar -->


  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar user panel (optional) -->
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="image">
          <img src="<?php echo e(asset('admin_lte/dist/img/user2-160x160.jpg')); ?>" class="img-circle elevation-2" alt="User Image">
        </div>
        <div class="info">
          <a href="#" class="d-block">Alexander Pierce</a>
        </div>
      </div>

      <!-- SidebarSearch Form -->
      <div class="form-inline">
        <div class="input-group" data-widget="sidebar-search">
          <input class="form-control form-control-sidebar" type="search" placeholder="Search" aria-label="Search">
          <div class="input-group-append">
            <button class="btn btn-sidebar">
              <i class="fas fa-search fa-fw"></i>
            </button>
          </div>
        </div>
      </div>

      <!-- Sidebar Menu -->
      <nav class="mt-2">
      <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
        <?php $__empty_1 = true; $__currentLoopData = $all_menu_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <?php //if (!empty(array_intersect(array('users','roles','permissions'), $user_permissions_names))): ?>          
        <li class="nav-item">
            <a href="<?php echo e(url('/admin')); ?>" class="nav-link <?php if(URL::full()==url('/')): ?> active <?php endif; ?>">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>Dashboard</p>
            </a>
        </li>
        <li class="nav-item">
            <a href="<?php echo e(url('/admin')); ?>" class="nav-link">
              <i class="nav-icon fas fa-th"></i>
              <p>Widgets</p>
            </a>
        </li>  
        <li class="nav-item" >                          
              <a href="<?php if($menu_item['type']=='module'): ?><?php echo route($menu_item['url']); ?> <?php else: ?> <?php echo e($menu_item['url']); ?> <?php endif; ?>" class="nav-link <?php if(Ch::isActive($menu_item['url'])): ?> active <?php endif; ?>">
              <i class="nav-icon fas fa <?php echo e($menu_item['icon']); ?>"></i>
              <p>
                    <?php echo e($menu_item['name']); ?>

                    <?php if(isset($menu_item['children']) && !empty($menu_item['children'])): ?>
                    <i class="right fas fa-angle-left"></i>
                    <?php endif; ?>

              </p>
              </a>
                <?php if(isset($menu_item['children']) && !empty($menu_item['children'])): ?>
                    <ul class="nav nav-treeview">
                    <?php $__empty_2 = true; $__currentLoopData = $menu_item['children']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu_item_children): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                    <li class="nav-item">
                        <a href="<?php if($menu_item_children['type']=='module'): ?> <?php echo route($menu_item_children['url']); ?> <?php else: ?> <?php echo e($menu_item_children['url']); ?> <?php endif; ?>" class="nav-link ">
                          <i class="far fa-circle nav-icon"></i>
                          <p><?php echo e($menu_item_children['name']); ?></p>
                        </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                    <?php endif; ?>
                    </ul>
                <?php endif; ?>
            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php endif; ?>
            <?php if(!empty(array_intersect(array('Invoices'), $user_permissions_names)) ): ?>
                <li class="nav-item">
                    <a href="<?php echo e(Route('InvoicesIndex')); ?>" class="nav-link <?php if(Ch::isActive('InvoicesIndex')): ?> active <?php endif; ?>">
                      <i class="nav-icon fas fa fa-chart-bar"></i>
                      <p>Invoices</p>
                    </a>
                </li>                                    
            <?php endif; ?>
            <?php if(!empty(array_intersect(array('modulebuilder_menu', 'modulebuilder_modules'), $user_permissions_names)) && Config::get('sysconfig.crudbuilder')): ?>                   
            <li class="nav-item <?php if(Ch::isActive(['modulebuildermenu','all_modules'])): ?> menu-open <?php endif; ?>" >                          
                <a href="#" class="nav-link <?php if(Ch::isActive(['modulebuildermenu','all_modules'])): ?> active <?php endif; ?>">
                <i class="nav-icon fa fa-cubes"></i>
                <p>
                      <?php echo app('translator')->get('crud_builder.menu_title'); ?>
                      <i class="right fas fa-angle-left"></i>
                </p>
                </a>
                <ul class="nav nav-treeview">
                <?php if(in_array('modulebuilder_menu', $user_permissions_names)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(Route('modulebuildermenu')); ?>" class="nav-link <?php if(Ch::isActive('modulebuildermenu')): ?> active <?php endif; ?>">
                      <i class="far fa-circle nav-icon"></i>
                      <p><?php echo app('translator')->get('menu.menu_title'); ?></p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(in_array('modulebuilder_modules', $user_permissions_names)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(Route('all_modules')); ?>" class="nav-link <?php if(Ch::isActive('all_modules')): ?> active <?php endif; ?>">
                      <i class="far fa-circle nav-icon"></i>
                      <p><?php echo app('translator')->get('modules.menu_title'); ?></p>
                    </a>
                </li>
                <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            <?php if(!empty(array_intersect(array('users', 'roles_all', 'permissions'), $user_permissions_names))): ?>                   
            <li class="nav-item <?php if(Ch::isActive(['users','roles','permissions'])): ?> menu-open <?php endif; ?>" >                          
                <a href="#" class="nav-link <?php if(Ch::isActive(['users','roles','permissions'])): ?> active <?php endif; ?>">
                <i class="nav-icon fa fa-users"></i>
                <p>
                      <?php echo app('translator')->get('manage_users.menu_title'); ?>
                      <i class="right fas fa-angle-left"></i>
                </p>
                </a>
                <ul class="nav nav-treeview">
                <?php if(in_array('user_all', $user_permissions_names)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(Route('users')); ?>" class="nav-link <?php if(Ch::isActive('users')): ?> active <?php endif; ?>">
                      <i class="far fa-circle nav-icon"></i>
                      <p><?php echo app('translator')->get('users.menu_title'); ?></p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(in_array('roles_all', $user_permissions_names)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(Route('roles')); ?>" class="nav-link <?php if(Ch::isActive('roles')): ?> active <?php endif; ?>">
                      <i class="far fa-circle nav-icon"></i>
                      <p><?php echo app('translator')->get('roles.menu_title'); ?></p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(in_array('permissions_all', $user_permissions_names)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(Route('permissions')); ?>" class="nav-link <?php if(Ch::isActive('permissions')): ?> active <?php endif; ?>">
                      <i class="far fa-circle nav-icon"></i>
                      <p><?php echo app('translator')->get('permissions.menu_title'); ?></p>
                    </a>
                </li>
                <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            <?php if(!empty(array_intersect(array('filemanager'), $user_permissions_names)) && Config::get('sysconfig.filemanager')): ?>                   
            <li class="nav-item" >                          
                <a href="#" class="nav-link">
                <i class="nav-icon fa fa-file"></i>
                <p>
                      <?php echo app('translator')->get('file_manager.menu_title'); ?>
                      <i class="right fas fa-angle-left"></i>
                </p>
                </a>
                <ul class="nav nav-treeview">
                <?php if(in_array('filemanager', $user_permissions_names)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('admin/laravel-filemanager')); ?>?type=Files" class="nav-link">
                      <i class="far fa-circle nav-icon"></i>
                      <p><?php echo app('translator')->get('file_manager.menu_title'); ?></p>
                    </a>
                </li>
                <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            <?php if(!empty(array_intersect(array('user_profile'), $user_permissions_names))): ?>
            <li class="nav-item <?php if(Ch::isActive(['userprofile','general-settings']) || URL::full()==url('admin/translations')): ?> menu-open <?php endif; ?>" >                          
                <a href="#" class="nav-link <?php if(Ch::isActive(['userprofile','general-settings'])): ?> active <?php endif; ?>">
                <i class="nav-icon fa fa-user-circle"></i>
                <p>
                <?php echo app('translator')->get('account_settings.menu_title'); ?>
                      <i class="right fas fa-angle-left"></i>
                </p>
                </a>
                <ul class="nav nav-treeview">
                <?php if(in_array('user_profile', $user_permissions_names)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('userprofile')); ?>" class="nav-link <?php if(Ch::isActive('userprofile')): ?> active <?php endif; ?>">
                      <i class="far fa-circle nav-icon"></i>
                      <p><?php echo app('translator')->get('user_profile.menu_title'); ?></p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(in_array('general_settings_all', $user_permissions_names)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('admin/general-settings')); ?>" class="nav-link <?php if(Ch::isActive('general-settings')): ?> active <?php endif; ?>">
                      <i class="far fa-circle nav-icon"></i>
                      <p><?php echo app('translator')->get('general_settings.menu_title'); ?></p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(in_array('translation-manager', $user_permissions_names)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('admin/translations')); ?>" class="nav-link <?php if(\URL::full()==url('admin/translations')): ?> active <?php endif; ?>">
                      <i class="far fa-circle nav-icon"></i>
                      <p><?php echo app('translator')->get('translations.menu_title'); ?></p>
                    </a>
                </li>
                <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            
            <?php if(!empty(array_intersect(array('user_profile'), $user_permissions_names))): ?>
            <li class="nav-item <?php if(Ch::isActive('ApiDocumentationIndex')): ?> menu-open <?php endif; ?>" >                          
                <a href="<?php echo e(Route('ApiDocumentationIndex')); ?>" class="nav-link <?php if(Ch::isActive('ApiDocumentationIndex')): ?> active <?php endif; ?>">
                <i class="nav-icon fa fa fa-code"></i>
                <p>Api Documentation</p>
                </a>
            </li>
            <?php endif; ?>
            </ul>
    </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <?php $__env->startSection('content'); ?>
    This is the master content.
    <?php echo $__env->yieldSection(); ?>
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->
<?php $__env->startSection('footer'); ?>
<?php echo $__env->yieldSection(); ?>
<!-- icheck -->
 <script src="<?php echo asset('assets/js/icheck/icheck.min.js') ?>"></script>
<!-- jQuery UI 1.11.4 -->
<script src="<?php echo e(asset('admin_lte/plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button)
</script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(asset('admin_lte/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- ChartJS -->
<script src="<?php echo e(asset('admin_lte/plugins/chart.js/Chart.min.js')); ?>"></script>
<!-- Sparkline -->
<script src="<?php echo e(asset('admin_lte/plugins/sparklines/sparkline.js')); ?>"></script>
<!-- JQVMap -->
<script src="<?php echo e(asset('admin_lte/plugins/jqvmap/jquery.vmap.min.js')); ?>"></script>
<script src="<?php echo e(asset('admin_lte/plugins/jqvmap/maps/jquery.vmap.usa.js')); ?>"></script>
<!-- jQuery Knob Chart -->
<script src="<?php echo e(asset('admin_lte/plugins/jquery-knob/jquery.knob.min.js')); ?>"></script>
<!-- daterangepicker -->
<script src="<?php echo e(asset('admin_lte/plugins/moment/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('admin_lte/plugins/daterangepicker/daterangepicker.js')); ?>"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="<?php echo e(asset('admin_lte/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js')); ?>"></script>
<!-- Summernote -->
<script src="<?php echo e(asset('admin_lte/plugins/summernote/summernote-bs4.min.js')); ?>"></script>
<!-- overlayScrollbars -->
<script src="<?php echo e(asset('admin_lte/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(asset('admin_lte/dist/js/adminlte.js')); ?>"></script>
<!-- AdminLTE for demo purposes -->
<!--<script src="<?php echo e(asset('admin_lte/dist/js/demo.js')); ?>"></script> -->
<!-- PNotify -->
<script type="text/javascript" src="<?php echo e(asset('assets/js/notify/pnotify.core.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('assets/js/notify/pnotify.buttons.js')); ?> "></script>
<script type="text/javascript" src="<?php echo e(asset('assets/js/notify/pnotify.nonblock.js')); ?>"></script>
</body>
</html>
<?php /**PATH /var/www/html/AppBuilderV4/resources/views/templates/admin_lte/master.blade.php ENDPATH**/ ?>